// TODO: revert tag hide-menu to show menu
define([
    'underscore',
    'backbone',
    'marionette',
    'text!modules/page/app-options-menu/app-options-menu.html',
], function(_, Backbone, Marionette, template) {
    'use strict';

    var KEY_CODE_TAB = 9;

    return Backbone.Marionette.View.extend({
        template: _.template(template),
        className: 'panel-menu',
        events: {
            'click .menu-close-btn, a': 'closePanel',

            'keydown .menu-close-btn': 'handleTabBackward',
            'keydown a:last-of-type': 'handleTabForward',
        },
        onRender: function() {
            this.delegateEvents();
            // TODO: pass references to any elemefnts outside of view on initialization of view
            this.ui = {
                panel: $('#menu'),
                button: function () {
                    return $('#menu-btn');
                },
            };
            this.ui.panel
                .trigger('create')
                .panel({
                    'open': function(event, ui) {
                        // focus on header
                        $(this).find('h3')
                            .focus();
                    },
                });
        },
        closePanel: function () {
            this.ui.panel.panel('close');
        },

        handleTabBackward: function (e) {
            if (e.shiftKey && e.which === KEY_CODE_TAB) {
                e.preventDefault();
                this.ui.button().focus();
            }
        },
        handleTabForward: function (e) {
            if (e.which === KEY_CODE_TAB && !e.shiftKey) {
                e.preventDefault();
                this.ui.button().focus();
            }
        },
    });
});
